unit MailU;

interface             

{$IFDEF WIN32}
uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DB, DBTables, ExtCtrls, WPStatus, Wpstat2, WpWinCtr, WPRich,
  WPTbar, Buttons, WPDEFS, ComCtrls, Tabnotbk, WPRuler, Menus;
{$ELSE}
uses
  WinProcs, WinTypes, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, DB, DBTables, ExtCtrls, WPStatus, Wpstat2, WpWinCtr, WPRich,
  WPTbar, Buttons, WPDEFS, Tabnotbk, WPRuler, Menus;
{$ENDIF}

type
  TForm1 = class(TForm)
    Panel2: TPanel;
    Button1: TButton;
    Bevel1: TBevel;
    FieldList: TListBox;
    Table1: TTable;
    OpenDialog1: TOpenDialog;    
    Label1: TLabel;
    WPToolBar1: TWPToolBar;
    Button2: TButton;
    MakeInsert: TBitBtn;
    Bevel2: TBevel;
    Label2: TLabel;
    Next: TSpeedButton;
    Prev: TSpeedButton;
    InsDate: TBitBtn;
    TabbedNotebook1: TTabbedNotebook;
    AllRtfText: TWPRichText;
    WPRichText1: TWPRichText;
    WPRuler1: TWPRuler;
    MergeAll: TBitBtn;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    LoadForm1: TMenuItem;
    SaveForm1: TMenuItem;
    N1: TMenuItem;
    SaveMergedText1: TMenuItem;
    N2: TMenuItem;
    Exit1: TMenuItem;
    WPAltStatusBar1: TWPAltStatusBar;
    Example1: TMenuItem;
    addtablerowwith3columns1: TMenuItem;
    Table3columns1: TMenuItem;
    N6columns1: TMenuItem;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FieldListClick(Sender: TObject);
    procedure MakeInsertClick(Sender: TObject);
    procedure PrevClick(Sender: TObject);
    procedure NextClick(Sender: TObject);
    procedure WPRichText1GetTextToInsert(Sender: TObject; var p: PChar;
      text: PChar; LenOfAutoText: Integer; tag: Word; c: Char;
      var DoContinue: Boolean);
    procedure InsDateClick(Sender: TObject);
    procedure WPToolBar1IconSelection(Sender: TObject; var Typ: TWpSelNr;
      const str: string; const group, num, index: Integer);
    procedure FormCreate(Sender: TObject);
    procedure MergeAllClick(Sender: TObject);
    procedure LoadForm1Click(Sender: TObject);
    procedure SaveForm1Click(Sender: TObject);
    procedure SaveMergedText1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure addtablerowwith3columns1Click(Sender: TObject);
    procedure Table3columns1Click(Sender: TObject);
    procedure N6columns1Click(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  protected
      procedure WMGetMinMaxInfo(var MSG: Tmessage); message WM_GetMinMaxInfo;
  public
    { static data to be used for mailmerging }
  {$IFNDEF WIN32}
    ptextbuff  : PChar;
    ptextsiz   : Integer;
  {$ELSE}
    textbuff : string;   { Delphis huge string }
  {$ENDIF}
    MinWidth  : Integer;
    MinHeight : Integer;

  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.WMGetMinMaxInfo(var MSG: Tmessage);
Begin
  inherited;
  with PMinMaxInfo(MSG.lparam)^ do
  begin
    with ptMinTrackSize do
    begin
      X := MinWidth;
      Y := MinHeight;
    end;
  end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
{$IFNDEF WIN32}
   ptextsiz := 10;
   GetMem(ptextbuff,10);
{$ENDIF}
  MinWidth  := 350;
  MinHeight := Height;
end;

procedure TForm1.Button1Click(Sender: TObject);
var
  nam : string;
begin
  if OpenDialog1.Execute then
  begin
     Table1.Active := FALSE;
     nam := OpenDialog1.FileName;
     Table1.DataBaseName :=
        ExtractFilePath(nam);
     Table1.TableName :=
        ExtractFileName(nam);
     try
        Label1.Caption := nam;
        Table1.Active := TRUE;
        Table1.GetFieldNames(FieldList.Items);
        Prev.Enabled := TRUE;
        Next.Enabled := TRUE;
     except
        Label1.Caption := 'cannot open';
     end;
  end;
end;

{ Switch between Viewmode and Editmode.
  The MailMerge variables (InsertPoints)
  are hidden in Viewmode.
  Note: If you save the text in Viewmode
  the InsertPoints are not saved.

  You can save the Text without the inserted
  Text when HideAutomatic = TRUE
}
procedure TForm1.Button2Click(Sender: TObject);
begin
   if not WPRichText1.Readonly then
   begin
     Button2.Caption := 'Viewmode OFF';
     WPRichText1.Readonly := TRUE;
     WPRichText1.HideInsertPoints := TRUE;
   end else
   begin
     Button2.Caption := 'Editmode OFF';
     WPRichText1.Readonly := FALSE;
     WPRichText1.HideInsertPoints := FALSE;
   end;
end;

procedure TForm1.FieldListClick(Sender: TObject);
begin
    MakeInsert.Enabled := (FieldList.ItemIndex>=0)
      and  not WPrichText1.Readonly and
      (FieldList.Items.Count>0);
end;


procedure TForm1.MakeInsertClick(Sender: TObject);
var
  i : Integer;
begin
  i := FieldList.ItemIndex;
  if (i>=0) and not WprichText1.ReadOnly
     and (TabbedNotebook1.PageIndex=0) then
  begin
     { Make an insertpoint:
       InputInsertpoint(c : Char;tag : Word;text : string);
       c = any character. for example '#'
       tag = 1..65535 will be used to distinguish between the points
       text will be merged at once
     }
     WPRichText1.InputInsertPoint('#',i+1,'['+FieldList.Items[i]+']');
     if WPRichText1.Visible then WPRichText1.SetFocus;
  end;
end;

procedure TForm1.InsDateClick(Sender: TObject);
begin
  if not WprichText1.ReadOnly then
  begin
     { Make an insertpoint:
       InputInsertpoint(c : Char;tag : Word;text : string);
       c = any character. for example '#'
       tag = 1..65535 will be used to distinguish between the points
       text will be merged at once
     }
     WPRichText1.InputInsertPoint('*',1000,'[DATE]');
     WPRichText1.SetFocus;
  end;

end;

{ This procedure will be called after WPRichText1.MergeText was
  called. It has to fill in the data to be inserted.
  You should never call any WPRichText procedure within
  the GetTextToInsert Eventhandler!
  var p: PChar;  This pointer has to be nil or should
                 point to the pchar which has to be inserted.
                 (attention: dont use local arrays)
  text: PChar;   The pointer let you know about the text
                 which follows the insertpoint. You vat all text
                 until lineend by reading this varible. It can be
                 used to do some calculation or to fill in the
                 previous data. (the lenght is then LenOfAutoText)
   LenOfAutoText: Integer;
                 If you want to use the previous data this will give
                 it to you as a string:
                 Copy(StrPas(text),1,LenOfAutoText);
   tag: Word;    The second important varaiable: The tag of the
                 insertpoint.
   c: Char;      Maybe of some use: The Character which shows
                 (colored in red) the insertpoint
   var DoContinue: Boolean
                 If you assign FALSE to DoContinue, the
                 merging will be stoped.
  }
procedure TForm1.WPRichText1GetTextToInsert(Sender: TObject; var p: PChar;
  text: PChar; LenOfAutoText: Integer; tag: Word; c: Char;
  var DoContinue: Boolean);
var
  field : TField;
  size  : Integer;
  s     : TMemoryStream;
begin
  if Tag=1000 then { Insert today date }
  begin
     {$IFDEF WIN32}
        TextBuff := DateToStr(Date);
        p := PChar(TextBuff);
     {$ELSE}
        if ptextbuff<>nil then FreeMem(ptextbuff,ptextsiz);
        ptextbuff := nil;
        ptextsiz := 30;
        GetMem(ptextbuff,30);
        StrPLCopy(ptextbuff,DateToStr(Date),28);
        p := ptextbuff;
     {$ENDIF}
  end
  else if (Tag>0) and (Tag<=FieldList.Items.Count) and Table1.Active then
  begin
     field := Table1.FieldByName(FieldList.Items.Strings[tag-1]);
     if field<>nil then
     begin
        {$IFDEF WIN32}
           TextBuff := field.AsString;;
           p := Pchar(TextBuff);
        {$ELSE}
           if field is TMemoField then
           begin
              try
                s := TMemoryStream.Create;
                (field as TMemoField).SaveToStream(s);
                Size := s.Size;
                if ptextbuff<>nil then FreeMem(ptextbuff,ptextsiz);
                ptextbuff := nil;
                ptextsiz := Size+10;
                GetMem(ptextbuff,ptextsiz);
                s.Position := 0;
                (ptextbuff + s.Read(ptextbuff^,size))^ := #0;
                s.Free;
              except
                ptextbuff := nil;
                s.Free;
              end;
           end else
           begin
              if ptextbuff<>nil then FreeMem(ptextbuff,ptextsiz);
              ptextbuff := nil;
              GetMem(ptextbuff,256);
              StrPLCopy(ptextbuff, field.AsString, 256);
           end;
           p := ptextbuff;
        {$ENDIF}
     end;
  end;
end;

procedure TForm1.PrevClick(Sender: TObject);
var
  s : TMemoryStream;
  old : Boolean;
begin
  if Table1.Active then
  begin
     Table1.Prior;
     Prev.Enabled := not Table1.BOF;
     Next.Enabled := not Table1.EOF;
     MergeAll.Enabled := not Table1.EOF;
     WPRichtext1.MergeText;
     try
       s := TMemoryStream.Create;
       old := WPRichText1.HideInsertPoints;
       WPRichText1.HideInsertPoints := TRUE;
       WPRichText1.SaveToStream(s);
       WPRichText1.HideInsertPoints := old;
       s.Position := 0;
       AllRtfText.CPPosition := $FFFFFF;
       AllRtfText.LoadFromStream(s);
     finally
       s.Free;
     end;
  end;
end;

procedure TForm1.NextClick(Sender: TObject);
var
  s : TMemoryStream;
  old : Boolean;
begin
  if Table1.Active then
  begin
     Table1.Next;
     Prev.Enabled := not Table1.BOF;
     Next.Enabled := not Table1.EOF;
     MergeAll.Enabled := not Table1.EOF;
     WPRichtext1.MergeText;
     try
       s := TMemoryStream.Create;
       old := WPRichText1.HideInsertPoints;
       WPRichText1.HideInsertPoints := TRUE;
       WPRichText1.SaveToStream(s);
       WPRichText1.HideInsertPoints := old;
       s.Position := 0;
       AllRtfText.CPPosition := $FFFFFF;
       AllRtfText.LoadFromStream(s);
     finally
       s.Free;
     end;
  end;
end;

{ please include WPDEFS to the usage }
procedure TForm1.WPToolBar1IconSelection(Sender: TObject;
  var Typ: TWpSelNr; const str: string; const group, num, index: Integer);
begin
  if typ=wptIconSel then
  begin
     if group=WPI_GR_DISK then
     begin if num=WPI_CO_NEW then
           begin
                 if TabbedNotebook1.PageIndex=0 then
                 begin
                   WPRichText1.Clear;
                   WPRichText1.CPPosition := 0;
                 end else
                 begin
                   AllRtfText.Clear;
                   AllRtfText.CPPosition := 0;
                   if Table1.Active then
                   begin Table1.First;
                         MergeAll.Enabled := TRUE;
                         Next.Enabled := TRUE;
                         Prev.Enabled := FALSE;
                   end;
                 end;
                 WPToolBar1.SelectIcon(index,group,num);
           end
           else if num= WPI_CO_EXIT then Close;
     end;
  end else
  if typ=wptIconDeSel then
  begin

  end;
end;


procedure TForm1.MergeAllClick(Sender: TObject);
var
  old : Boolean;
  var i : Longint;
begin
  i := 0;
  if not Table1.Active then exit;
  AllRtfText.HideInsertPoints := TRUE;
  AllRtfText.FastCopyProperties(WPRichText1);
  if MessageBox(0,'Merge all Records in Database?',
        'MailMerge',IDOK)=IDOK then
  try
    while not Table1.EOF do
    begin
     inc(i);
     WPAltStatusBar1.SetString(stStatus,IntToStr(i));
     Table1.Next;
     WPRichtext1.FastMergeText;
     AllRtfText.Memo.FastAppendText(WPRichText1.Memo.FirstPar);
    end;
  finally
    { After usage of FastAppendText it is neccessary to call Refresh }
    AllRtfText.Refresh;
    { the usage of FastMergeText makes it necessary to call Refresh }
    WPRichtext1.Refresh;

    Prev.Enabled := not Table1.BOF;
    Next.Enabled := not Table1.EOF;
    MergeAll.Enabled := not Table1.EOF;
  end;
end;

procedure TForm1.LoadForm1Click(Sender: TObject);
begin
   WPRichText1.Load;    
end;

procedure TForm1.SaveForm1Click(Sender: TObject);
var
  old : Boolean;
begin
  old :=  WPRichText1.HideInsertPoints;
  { WPRichText1.HideInsertPoints has to be FALSE. Otherwise
    the insertpoints won't be saved }
  WPRichText1.HideInsertPoints := FALSE;
  WPRichText1.SaveAs;
  WPRichText1.HideInsertPoints := old;
end;

procedure TForm1.SaveMergedText1Click(Sender: TObject);
begin
   AllRtfText.SaveAs;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TForm1.addtablerowwith3columns1Click(Sender: TObject);
var
   CWidth : array[1..5] of Integer;
const
   mult = 255 div 6;
begin
   WPRichText1.Clear;
   CWidth[1] := mult;
   CWidth[2] := mult * 2;
   CWidth[3] := mult * 3;
   WPRichText1.CreateTable(1,3,@Cwidth[1],FALSE);
end;

procedure TForm1.Table3columns1Click(Sender: TObject);
var
   CWidth : array[1..5] of Integer;
const
   mult = 255 div 6;
begin
   WPRichText1.Clear;
   CWidth[1] := mult;
   CWidth[2] := mult * 2;
   CWidth[3] := mult * 3;
   WPRichText1.CreateTable(1,3,@Cwidth[1],TRUE);
end;

procedure TForm1.N6columns1Click(Sender: TObject);
begin
   WPRichText1.Clear;
   WPRichText1.CreateTable(1,6,nil,TRUE);
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
{$IFNDEF WIN32}
  FreeMem(ptextbuff,ptextsiz);
{$ENDIF}
end;

end.
